<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class CreateDefaultSettingsForRevisionContentTypes extends Migration
{
    public function up(): void
    {
        $projectCode = config('app.code');

        $contentTypesByProject = [
            'naus' => ['news', 'documents', 'events'],
            'apso' => ['news', 'events', 'documents'],
            'fepl' => ['news', 'events', 'documents'],
            'spee' => ['news', 'documents', 'events', 'pages', 'spaces_pages', 'tabs_pages'],
            'cmag' => ['news', 'documents', 'events'],
            'prae' => ['news', 'documents', 'events'],
            'bcae' => ['news', 'events', 'documents'],
            'isgg' => ['news', 'documents', 'constitution_articles', 'governments', 'spaces_pages', 'pages', 'tabs_pages'],
            'isvp' => ['news', 'events', 'documents'],
            'orsy' => ['news', 'documents', 'events', 'pages', 'spaces_pages', 'tabs_pages'],
            'demo' => ['news', 'events', 'documents'],
            'sid2' => ['news', 'documents', 'events'],
            'apro' => ['news', 'documents', 'events', 'faq_categories', 'faq_questions', 'franchises', 'marker', 'providers', 'provider_documents'],
            'expt' => ['tabs_pages'],
            'bmha' => ['news', 'documents', 'events'],
            'fare' => ['news', 'events', 'documents'],
            'liry' => ['news', 'documents', 'events'],
            'idex' => ['news', 'documents', 'events'],
            'reso' => ['news', 'documents', 'events'],
            'bclh' => ['rops', 'sops'],
            'desk' => ['news', 'events', 'memorandums', 'career_infos', 'p_and_p'],
            'syan' => ['news', 'documents'],
        ];

        if (isset($contentTypesByProject[$projectCode])) {
            Setting::updateOrCreate(
                attributes: ['group' => 'contentManagement', 'key' => 'revision_content_types'],
                values: ['value' => json_encode($contentTypesByProject[$projectCode])]
            );
        }
    }
}
