<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class CreateDeeplApiKeySettings extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(['key' => 'deepl_api_key', 'group' => 'automaticTranslation'], ['value' => env('DEEPL_AUTH_KEY', '')]);
    }
}
