<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class CreateOpenWeatherApiKeySettings extends Migration
{
    public function up(): void
    {
        Setting::where(['group' => 'weather', 'key' => 'openai_api_key'])->first()?->delete();
        Setting::updateOrCreate(['key' => 'open_weather_api_key', 'group' => 'weather'], ['value' => env('OPENWEATHERMAP_API_KEY', '')]);
    }
}
