<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class SetDefaultFileExtensions extends Migration
{
    public function up(): void
    {
        if (config('app.code') === 'iide') {
            Setting::updateOrCreate(['group' => 'contentManagement', 'key' => 'file_extensions'], ['value' => '["zip","rar","txt","csv","sketch","ai","indd","psd","pdf","ae","prproj","xd","muse","doc","docx","docm","xls","xlsx","xlsm","xltx","xltm","xlsb","ppt","pptx","pptm","pub","vsd","vsdx","one","pot","potx","potm","dot","dotx","dotm","xsn","mpp","wps","odt","ods","odp","odg","odf","odb","ott","ots","otp","otg","oth","odm","sxw","sxc","sxi","sxg","stw","stc","png","gif","jpg","jpeg","bmp","webp","svg","tif","mp3","oft","msg","otf","odft"]']);
        } else {
            Setting::updateOrCreate(['group' => 'contentManagement', 'key' => 'file_extensions'], ['value' => '["docx","xd","pdf","ai","zip","csv","ae","prproj","psd","indd","sketch","rar","txt","doc","muse","odft","otf","msg","oft","mp3","tif","svg","webp","bmp","heif","heic","jpeg","jpg","gif","png","webm","mov","avi","mp4","stc","stw","sxg","sxi","sxc","sxw","odm","oth","otg","otp","ots","ott","odb","odf","odg","odp","odt","ods","docm","xls","xlsm","xlsx","xltx","wps","mpp","xsn","dotm","dotx","dot","potm","potx","pot","one","vsdx","vsd","pub","pptm","pptx","ppt","xlsb","xltm"]']);
        }

        Setting::updateOrCreate(['group' => 'contentManagement', 'key' => 'img_extensions'], ['value' => '["png","gif","jpg","jpeg","heif","heic","bmp","webp","jfif"]']);
        Setting::updateOrCreate(['group' => 'contentManagement', 'key' => 'video_extensions'], ['value' => '["mp4","avi","mov","webm"]']);
    }
}
