<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class EnableAvatarEdition extends Migration
{
    public function up(): void
    {
        $instances = [
            'alfa',
            'aljt',
            'coro',
            'dunk',
            'gasb',
            'gfac',
            'isdr',
            'isod',
            'lied',
            'quan',
            'sete',
            'work',
        ];

        if (in_array(config('app.code'), $instances)) {
            Setting::updateOrCreate(['group' => 'profile', 'key' => 'enable_avatar_edition'], ['value' => null]);
        } else {
            Setting::updateOrCreate(['group' => 'profile', 'key' => 'enable_avatar_edition'], ['value' => true]);
        }
    }
}
