<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class SeedEmailAndSenderMailOptions extends Migration
{
    public function up(): void
    {
        collect(['from_name', 'from_address'])->each(function (string $key) {
            $currentValue = setting(group: 'email', key: $key);
            if (blank($currentValue)) {
                $newValue = env('MAIL_'.strtoupper($key), null);
                Setting::updateOrCreate(['key' => $key, 'group' => 'email'], ['value' => $newValue]);
            }
        });
    }
}
