<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddSearchEngineInfo extends Migration
{
    public function up(): void
    {
        $driver = config('scout.driver');
        Setting::updateOrCreate(['key' => 'search_engine', 'group' => 'general'], ['value' => $driver]);
    }
}
