<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddFontSizeValues extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(['key' => 'font_size_h1', 'group' => 'general'], ['value' => $this->h1()]);
        Setting::updateOrCreate(['key' => 'font_size_h2', 'group' => 'general'], ['value' => $this->h2()]);
        Setting::updateOrCreate(['key' => 'font_size_h3', 'group' => 'general'], ['value' => $this->h3()]);
        Setting::updateOrCreate(['key' => 'font_size_h4', 'group' => 'general'], ['value' => $this->h4()]);
        Setting::updateOrCreate(['key' => 'font_size_h5', 'group' => 'general'], ['value' => $this->h5()]);
        Setting::updateOrCreate(['key' => 'font_size_labor', 'group' => 'general'], ['value' => $this->labor()]);
        Setting::updateOrCreate(['key' => 'font_size_tiny', 'group' => 'general'], ['value' => 11]);
    }

    protected function h1(): int
    {
        return match (strtoupper(config('app.code'))) {
            'AGFR' => 33,
            'ALBE', 'EMMA', 'PETI', 'SSTI' => 32,
            'CORO', 'FEPS' => 31,
            'DUNK' => 36,
            'EPAR' => 31,
            'FARE', 'TIK2' => 30,
            'HPSJ' => 27,
            'SBIN', 'SYCT' => 29,
            default => 34,
        };
    }

    protected function h2(): int
    {
        return match (strtoupper(config('app.code'))) {
            'AGFR' => 27,
            'ALBE', 'SSTI', 'PETI', 'HPSJ', 'EMMA' => 26,
            'CORO' => 23,
            'DUNK' => 30,
            'EPAR', 'TIK2', 'SYCT', 'FEPS', 'FARE' => 25,
            'SBIN' => 24,
            default => 28,
        };
    }

    protected function h3(): int
    {
        return match (strtoupper(config('app.code'))) {
            'ALBE', 'EMMA', 'EPAR', 'HPSJ', 'SSTI' => 22,
            'CORO', 'SBIN' => 20,
            'DUNK' => 25,
            'FARE', 'FEPS', 'PETI', 'SYCT', 'TIK2' => 21,
            default => 23,
        };
    }

    protected function h4(): int
    {
        return match (strtoupper(config('app.code'))) {
            'ALBE', 'SSTI', 'PRAE', 'EPAR', 'EMMA' => 18,
            'ARES', 'TIK2', 'SBIN', 'FEPS', 'FARE', 'CORO' => 17,
            'DUNK' => 21,
            'HPSJ' => 20,
            'SYCT' => 16,
            default => 19,
        };
    }

    protected function h5(): int
    {
        return match (strtoupper(config('app.code'))) {
            'CORO', 'EPAR', 'FARE', 'FEPS', 'SYCT', 'TIK2' => 15,
            'SBIN' => 14,
            default => 16,
        };
    }

    protected function labor(): int
    {
        return match (strtoupper(config('app.code'))) {
            'ICHB', 'IPRI', 'PPLH' => 16,
            'AGEO', 'ALBE', 'EMMA' => 15,
            'PETI', 'SYCT' => 13,
            default => 14,
        };
    }
}
