<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use Inside\Services\FaviconsGeneratorService;
use Inside\Settings\Models\Setting;

final class AddGeneralFavicon extends Migration
{
    public function up(): void
    {
        if (! File::exists(theme_path('assets/app-logo/site.webmanifest'))) {
            setting('general', ['favicon' => null]);

            return;
        }

        DB::table('inside_settings')->updateOrInsert(
            ['key' => 'favicon', 'group' => 'general'],
            ['value' => 'assets/favicons/original.png']
        );

        $manifest = json_decode(File::get(theme_path('assets/app-logo/site.webmanifest')), true);
        $files = collect($manifest['icons'])->pluck('src')->map(fn ($path) => trim($path, '/'));

        $biggest = $files->sortByDesc(function ($filename) {
            preg_match('/(\d+)x(\d+)/', $filename, $matches);

            return isset($matches[1]) ? (int) $matches[1] * (int) $matches[2] : 0;
        })->first();

        $files->merge([
            'apple-touch-icon.png',
            'favicon.ico',
            'favicon-16x16.png',
            'favicon-32x32.png',
            'favicon-48x48.png',
            'site.webmanifest',
        ]);

        File::copy(theme_path('assets/app-logo').'/'.$biggest, storage_path('app/'.FaviconsGeneratorService::PATH).'/original.png');

        foreach ($files as $file) {
            $path = theme_path('assets/app-logo').'/'.$file;
            if (File::exists($path)) {
                File::copy($path, storage_path('app/'.FaviconsGeneratorService::PATH).'/'.$file);
            }
        }
    }
}
