<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddEmailSendingEnabledOption extends Migration
{
    public function up(): void
    {
        $isEnabled = str(env('MAIL_DRIVER', 'logs'))->lower()->toString() !== 'logs';
        Setting::updateOrCreate(['key' => 'email_sending_enabled', 'group' => 'email'], ['value' => $isEnabled]);
    }
}
