<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Content\Facades\Schema as InsideSchema;
use Inside\Host\Bridge\BridgeContentType;
use Inside\Settings\Models\Setting;

final class EnableCommentsAndSetDefaultValue extends Migration
{
    public function up(): void
    {
        $bridge = new BridgeContentType();

        $contentWithoutComments = collect([
            'news',
            'events',
        ]);

        $contentWithoutComments->each(function ($contentType) use ($bridge) {
            if (! InsideSchema::hasModel($contentType)) {
                return;
            }

            if (InsideSchema::hasField($contentType, 'comments')) {
                return;
            }

            $bridge->contentTypeCreateOrUpdateField(
                type: $contentType,
                fieldName: 'comments',
                options: [
                    'name' => 'comments',
                    'searchable' => false,
                    'translatable' => true,
                    'search_result_field' => false,
                    'searchable_filter' => false,
                    'required' => false,
                    'weight' => 6,
                    'title' => [
                        'fr' => 'Commentaires',
                        'en' => 'Comments',
                        'es' =>'Comentarios',
                        'pt' =>'Comentários',
                        'de' =>'Kommentare',
                        'nl' =>'Opmerkingen',
                    ],
                    'widget' => [
                        'hidden' => true,
                    ],
                    'type' => BridgeContentType::COMMENT_FIELD,
                    'settings' => [
                        'comment_type' => 'comments',
                        'cardinality' => 1,
                    ],
                ]);
        });

        $defaultSettings = [
            [
                'Instance' => 'afp2',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'agen',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'apas',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'ares',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'bclh',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'bpam',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'club',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'cnos',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'cpas',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'cuis',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'desk',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'efsa',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'emma',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'epar',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'gasb',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'ggth',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'ging',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'ifvd',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',

            ],
            [
                'Instance' => 'inmu',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'isdr',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'ixif',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'kera',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'mslh',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'nckl',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',

            ],
            [
                'Instance' => 'nfh2',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'opti',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'pplh',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
                'ged_enable_likes' => 'false',
            ],
            [
                'Instance' => 'quan',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'rhlh',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'scea',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'sete',
                'news_enable_comments' => 'false',
                'events_enable_comments' => 'false',
            ],
            [
                'Instance' => 'syct',
                'news_enable_likes' => 'false',
                'news_enable_comments' => 'false',
                'events_enable_likes' => 'false',
                'events_enable_comments' => 'false',

            ],
        ];

        $appCode = config('app.code');

        $settings = collect([
            'news_enable_likes',
            'news_enable_comments',
            'events_enable_likes',
            'events_enable_comments',
            'ged_enable_likes',
        ]);

        $defaultSettings = collect($defaultSettings)->filter(function ($setting) use ($appCode) {
            return $setting['Instance'] === $appCode;
        })->first();

        $settings->each(function ($setting) use ($defaultSettings) {
            if (! isset($defaultSettings[$setting])) {
                Setting::updateOrCreate(['key' => $setting, 'group' => 'reactions'], ['value' => true]);

                return;
            }
            Setting::updateOrCreate(['key' => $setting, 'group' => 'reactions'], ['value' => null]);
        });
    }
}
