<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddSearchTypeDefaultValue extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(['key' => 'search_type', 'group' => 'general'], ['value' => 'relevance']);
    }

    public function down(): void
    {
        Setting::where(['key' => 'search_type', 'group' => 'general'])->delete();
    }
}
