<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class UpdateFontsSetting extends Migration
{
    public function up(): void
    {
        collect([
            'font_source_primary' => null,
            'font_source_secondary' => null,
        ])->each(fn ($value, $key) => Setting::firstOrCreate(
            attributes: ['group' => 'general', 'key' => $key],
            values: ['value' => $value]
        ));
        Setting::where(['key' => 'font_source', 'group' => 'general'])->delete();
    }
}
