<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class CreateFontsSetting extends Migration
{
    public function up(): void
    {
        collect([
            'font_primary_google',
            'font_secondary_google',
            'font_primary_import_light',
            'font_primary_import_normal',
            'font_primary_import_bold',
            'font_secondary_import_light',
            'font_secondary_import_normal',
            'font_secondary_import_bold',
            'font_source',
        ])->each(fn ($key) => Setting::firstOrCreate(
            attributes: ['group' => 'general', 'key' => $key],
            values: ['value' => null]
        ));
    }
}
