<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Illuminate\Support\Facades\Log;
use Inside\Settings\Models\Setting;

final class UpdateDefaultSettings extends Migration
{
    public function up(): void
    {
        $groupKeyMapping = [
            'appearance' => [
                'meta_title' => 'identity',
                'color_primary' => 'identity',
                'color_secondary' => 'identity',
            ],
            'programmed-content' => [
                'plannedMark_general' => 'identity',
            ],
        ];

        collect($groupKeyMapping)->each(function ($keys, $oldGroup) {
            collect($keys)->each(function ($newGroup, $key) use ($oldGroup) {
                try {
                    Setting::updateOrCreate(
                        ['group' => $oldGroup, 'key' => $key],
                        ['group' => $newGroup]
                    );
                } catch (\Exception $e) {
                    Log::error('Update settings : '.$e->getMessage());
                }
            });
        });
    }
}
