<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class CreateShowLogoutButton extends Migration
{
    public function up(): void
    {
        Setting::firstOrCreate(
            ['key' => 'show_logout_button', 'group' => 'profile'],
            ['value' => true]
        );
    }

    public function down(): void
    {
        Setting::where(
            ['key' => 'show_logout_button', 'group' => 'profile']
        )->delete();
    }
}
