<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class UpdateMetaTitleKeySettingsValue extends Migration
{
    public function up(): void
    {
        Setting::updateOrCreate(['key' => 'meta_title', 'group' => 'identity'], ['value' => env('APP_NAME')]);
    }

    public function down(): void
    {
        Setting::where(['key' => 'meta_title', 'group' => 'identity'])->delete();
    }
}
