<?php

declare(strict_types=1);

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

final class AddResetPasswordEnabledSetting extends Migration
{
    public function up(): void
    {
        $value = match (config('app.code')) {
            'ichb', 'scea', 'web2' => null,
            default => true,
        };

        Setting::updateOrCreate(['key' => 'reset_password_enabled', 'group' => 'loginpage'], ['value' => $value]);
    }

    public function down(): void
    {
        Setting::where(['key' => 'reset_password_enabled', 'group' => 'loginpage'])->delete();
    }
}
