<?php

use Illuminate\Database\Migrations\Migration;
use Inside\Settings\Models\Setting;

class AddDefaultDirectorySettingsKeys extends Migration
{
    public function up(): void
    {
        collect([
            ['group' => 'directory', 'key' => 'display_directory', 'value' => 'table'],
            ['group' => 'directory', 'key' => 'sort_directory', 'value' => 'asc_lastname'],
        ])->each(static function ($setting) {
            if (Setting::where('group', $setting['group'])->where('key', $setting['key'])->doesntExist()) {
                Setting::create($setting);
            }
        });
    }
}
