<?php

namespace Inside\Search\Providers;

use Inside\Search\Console\IndexCommand;
use Inside\Search\Console\IndexMissingContentCommand;
use Inside\Search\Console\StructureCommand;
use Inside\Search\Contracts\Search as SearchContract;
use Inside\Search\Helpers\Searchable;
use Inside\Search\Services\Search as SearchService;
use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

/**
 * Inside search service providers
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SearchServiceProvider extends EventServiceProvider
{
    protected array $commands = [
        IndexCommand::class,
        StructureCommand::class,
        IndexMissingContentCommand::class,
    ];

    public array $bindings = [
    ];

    public array $singletons = [
        SearchContract::class => SearchService::class,
    ];

    public function boot(): void
    {
    }

    /**
     * Register the application services.
     *
     * @return void
     */
    public function register(): void
    {
        // Get scout config
        try {
            $this->mergeConfigTo(__DIR__.'/../../config/scout.php', 'scout');
            $this->mergeConfigTo(__DIR__.'/../../config/stopwords.php', 'stopwords');
            $this->mergeConfigTo(__DIR__.'/../../config/tika.php', 'tika');
            $this->mergeConfigFrom(__DIR__.'/../../config/history.php', 'history');
            $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
        } catch (NotFoundExceptionInterface|ContainerExceptionInterface) {
        }

        // Easy alias on Searchable
        $this->app->insideAlias('Search', Searchable::class);
    }
}
