<?php

namespace Inside\Search\Http\Controllers;

use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Permission\Exceptions\AuthorizationException;
use Inside\Search\Models\SearchHistory;

class HistoryDestroy extends Controller
{
    /**
     * @throws Exception
     */
    public function __invoke(Request $request, string $id): JsonResponse
    {
        /** @var ?User $me */
        $me = Auth::user();

        if (! inside_search_history_enabled() || ! $me) {
            throw new AuthorizationException('This action is unauthorized.');
        }

        SearchHistory::where('user_uuid', $me->uuid)->where('id', $id)->delete();

        return response()->json([
            'data' => $this->getSearchHistory($me),
        ]);
    }
}
