<?php

namespace Inside\Search\Http\Controllers;

use Exception;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Services\Queries\ContentQueryHelper;
use Inside\Search\Contracts\Search as SearchContract;
use OpenApi\Annotations as OA;

class GenericSearch extends Controller
{
    /**
     * @throws Exception
     */
    public function __invoke(Request $request, SearchContract $service): JsonResponse
    {
        return response()->json($service->withRequest($request)->search());
    }
}

/**
 * @OA\Schema(
 *     schema="SearchResult",
 *     type="object",
 *     @OA\Property(
 *     property="current_page",
 *     description="La page actuelle du résultat",
 *     type="integer"
 *     ),
 *     @OA\Property(
 *     property="first_page_url",
 *     description="L'url pour accéder à la première page des résultats de la recherche",
 *     type="string"
 *     ),
 *     @OA\Property(
 *     property="from",
 *     description="Index du premier résultat de la page",
 *     type="integer"
 *     ),
 *     @OA\Property(
 *     property="to",
 *     description="Index du dernier résultat de la page",
 *     type="integer"
 *     ),
 *     @OA\Property(
 *     property="per_page",
 *     description="Nombre de résultat par page ( correspond en principe au filtre 'limit' des paramètres )",
 *     type="integer"
 *     ),
 *     @OA\Property(
 *     property="last_page",
 *     description="Numéro de la dernière page",
 *     type="integer"
 *     ),
 *     @OA\Property(
 *     property="last_page_url",
 *     description="L'url pour accéder à la dernière page des résultats de la recherche",
 *     type="string"
 *     ),
 *     @OA\Property(
 *     property="total",
 *     description="Nombre total de résultat",
 *     type="integer",
 *     example=2345
 *     ),
 *     @OA\Property(
 *     property="next_page_url",
 *     description="L'url pour accéder à la page suivante des résultats de la recherche",
 *     type="string",
 *     nullable=true
 *     ),
 *     @OA\Property(
 *     property="prev_page_url",
 *     description="L'url pour accéder à la page précédente des résultats de la recherche",
 *     type="string",
 *     nullable=true
 *     ),
 *     @OA\Property(
 *     property="path",
 *     description="Url du moteur de recherche",
 *     type="string"
 *     ),
 *     @OA\Property(
 *     property="data",
 *     description="Tableau des résultats. La liste des champs est accompagnée de tous les champs qui sont coché
 *  en back office comme 'search index result'.",
 *     type="array",
 *     items=@OA\Items(@OA\schema(
 *        type="object",
 *        @OA\Property(
 *        property="score",
 *        description="Le score de la recherche, plus le score est élevé et plus ce résutlat répond aux critères
 *     de recherche.",
 *        type="integer"
 *        ),
 *        @OA\Property(
 *        property="content_type",
 *        description="Le type de contenu",
 *        type="string",
 *        example="news"
 *        ),
 *        @OA\Property(
 *        property="admin",
 *        description="Les paramètres de permissions",
 *        type="string"
 *        ))
 *     )
 *     )
 * )
 *
 * @OA\Schema(
 *                 schema="FilterParameter",
 *                 type="object",
 *                 @OA\Property(
 *                     property="order",
 *                     description="Indique l'ordre des résultats souhaités et sa direction ( asc/desc ) séparé par
 *                     un ':' ( exemple: title:asc ou score:desc ).", type="string", default="sort:asc"
 *                 ),
 * @OA\Property(
 *                     property="langcode",
 *                     description="La langue des résultats désirée. Par défaut, le résultat de la recherche donne
 *                     le résultat dans toutes les langues.", type="string"
 *                 ),
 * @OA\Property(
 *                     property="status",
 *                     description="Le status des contenus du résultat. Par défaut, les résultat de la recherche
 *                     donne le résultat quelque soit le status du contenu.", type="integer"
 *                 ),
 * @OA\Property(
 *                     property="in",
 *                     description="Quels sont les types de contenu désiré. Par défaut, le résultat de la recherche
 *                     donne les résultats quelque soit son type.", type="array",
 *                     @OA\Items(type="string"),
 *                     default={}
 *                 ),
 * @OA\Property(
 *                     property="global",
 *                     description="La recherche est-elle globale",
 *                     type="boolean",
 *                     example=true,
 *                     default=false
 *                 ),
 * @OA\Property(
 *                     property="limit",
 *                     description="Le nombre de résultat désiré. Si limit est nul alors tous les résultats sont
 *                     retourné.", type="integer", default=0
 *                 ),
 *                 example={"order":"score:desc","langcode":"fr","status":1,"limit":10,"in":{},"locations":""}
 *             )
 *            }
 *
 * @OA\Get(
 *      path="/search",
 *      operationId="search",
 *      tags={"Recherche"},
 *      summary="Utilise le moteur de recherche installé pour rechercher parmi les contenus 'searchable' selon un
ou plusieurs termes désirés", description="Retourne la liste des contenus répondant aux critères de
recherche",
 *     @OA\Parameter(
 *         name="query",
 *         in="query",
 *         description="Le ou les termes recherchés",
 *         required=true,
 *         @OA\Schema(
 *             type="string"
 *         )
 *     ),
 *     @OA\Parameter(
 *         name="page",
 *         in="query",
 *         description="La page demandée si limite est différent de 0",
 *         required=false,
 *         @OA\Schema(
 *             type="integer"
 *         )
 *     ),
 *     @OA\Parameter(
 *         name="filters",
 *         in="query",
 *         description="Les filtres à appliquer.
 **Note importante**: Pour respecter le système de filtre du type de
contenu (inside-content), le système de recherche accepte les filtres sur les référence du type
country => [uuid:eq => *uuid*], cependant, le format attendu du moteur de recherche est en fait country => *uuid*,
il n'y a donc que les cas suivant qui seront prit en compte country => [uuid:eq => *uuid*],
country => [uuid => *uuid*].",
 *         required=false,
 *      @OA\Schema(type="string",format="json")
 *      ),
 *      @OA\Response(
 *          response=200,
 *          description="Les résultats de la recherche au format JSON",
 *          @OA\JsonContent(ref="#/components/schemas/SearchResult")
 *       ),
 *      @OA\Response(response=400, description="Bad request")
 *     )
 */
