<?php

use Illuminate\Database\Migrations\Migration;

class PrepareTitleFieldsForSearch extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        /**
         * These are special drupal fields that can't be edited in drupal backoffice
         */
        $toBeSet = ['title', 'author', 'status', 'created_at', 'updated_at', 'langcode'];

        /**
         * Update all special drupal field that want to be in search result
         */
        Inside\Content\Models\Field::whereIn('name', $toBeSet)->each(function ($fieldConfig) {
            $options = $fieldConfig->options;
            $options['search_result_field'] = true;
            $fieldConfig->options = $options;
            $fieldConfig->save();
        });
    }
}
