<?php

namespace Inside\Reaction\Providers;

use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Transformers\ContentTransformer;
use Inside\Reaction\Console\CleanupCommand;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;
use Inside\Reaction\Listeners\CleanupReactionOnContentDeletetion;
use Inside\Reaction\Listeners\ReactionListener;
use Inside\Reaction\Services\ReactionService;
use Inside\Reaction\Validators\ReactionValidator;
use Inside\Support\EventServiceProvider;
use Psr\Container\ContainerExceptionInterface;
use Psr\Container\NotFoundExceptionInterface;

class ReactionServiceProvider extends EventServiceProvider
{
    protected array $listen = [
        ContentDeletedEvent::class => [
            CleanupReactionOnContentDeletetion::class,
        ],
        ReactionSubscribedEvent::class => [
            ReactionListener::class,
        ],
        ReactionUnsubscribedEvent::class => [
            ReactionListener::class,
        ],
    ];

    protected array $commands = [
        CleanupCommand::class,
    ];

    /**
     * @throws ContainerExceptionInterface
     * @throws NotFoundExceptionInterface
     */
    public function register(): void
    {
        $this->mergeRecursiveConfigFrom(__DIR__.'/../../config/scheduler.php', 'scheduler');
        $this->app->singleton(
            ReactionService::class,
            function () {
                return new ReactionService(new ContentTransformer(), new ReactionValidator());
            }
        );
    }
}
