<?php

namespace Inside\Reaction\Listeners;

use Inside\Content\Exceptions\FieldSchemaNotFoundException;
use Inside\Content\Facades\ContentCache;
use Inside\Content\Facades\Schema;
use Inside\Reaction\Events\ReactionSubscribedEvent;
use Inside\Reaction\Events\ReactionUnsubscribedEvent;
use Inside\Reaction\Models\Reaction;

class ReactionListener
{
    public function handle(ReactionSubscribedEvent|ReactionUnsubscribedEvent $event): void
    {
        $this->forgetCache($event->reaction);
    }

    protected function forgetCache(Reaction $reaction): void
    {
        $type = class_to_type($reaction->reactionable_type);
        $tags = ContentCache::getTags($type);

        try {
            $fields = Schema::getFieldListing($type);
        } catch (FieldSchemaNotFoundException) {
            $fields = [];
        }

        foreach ($fields as $fieldName) {
            $fieldOptions = Schema::getFieldOptions($type, $fieldName);
            if (in_array($fieldOptions['type'], ['reference', 'comments', 'reactions'])) {
                $tags = array_merge($tags, (array) $fieldOptions['target']);
            }
        }

        ContentCache::forget($tags);
    }
}
