<?php

namespace Inside\Reaction\Listeners;

use Exception;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Reaction\Models\Reaction;

class CleanupReactionOnContentDeletetion
{
    /**
     * @throws Exception
     */
    public function handle(ContentDeletedEvent $event): void
    {
        if (! $event->model) {
            return;
        }

        if (class_to_type($event->model) == 'users') {
            Reaction::where('user_uuid', $event->model->uuid)->delete();
        }
        Reaction::where('reactionable_uuid', $event->model->uuid)->where(
            'reactionable_type',
            get_class($event->model)
        )->delete();
    }
}
