<?php

namespace Inside\Reaction\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Permission\Exceptions\AuthorizationException;
use Inside\Reaction\Facades\Reactions;
use Inside\Reaction\Models\Reaction;

class Unsubscribe extends Controller
{
    public function __invoke(string $type, string $related, string $userUuid, Request $request): JsonResponse
    {
        /** @var User $user */
        $user = Auth::user();
        if ($user->uuid != $userUuid) {
            throw AuthorizationException::create('Unsubscribe', $type);
        }
        $filters = ContentHelper::extractFiltersInputFromRequest($request);

        $reaction = Reactions::get($type, $related, $userUuid, $filters['langcode'] ?? null, null, ['reactionable_type'], false)->first();

        if ($reaction->reactionable_type) {
            $class = $reaction->reactionable_type;
            $requestedContent = call_user_func($class.'::findOrFail', $related);
            $translatedContents = $class::where('uuid_host', $requestedContent->uuid_host)->get();

            $translatedContents->each(
                fn ($content) => Reaction::query()
                    ->where('type', $type)
                    ->where('user_uuid', $userUuid)
                    ->where('reactionable_type', $class)
                    ->where('reactionable_uuid', $content->uuid)
                    ->first()
                    ?->delete()
            );
        } else {
            Reactions::delete($type, $related, $user->uuid, $filters['langcode'] ?? null);
        }

        return response()->json(
            [
                'status' => true,
            ]
        );
    }
}
