<?php

namespace Inside\Reaction\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Str;
use Inside\Authentication\Models\User;
use Inside\Content\Facades\ContentHelper;
use Inside\Reaction\Facades\Reactions;

class Subscribe extends Controller
{
    public function __invoke(Request $request): JsonResponse
    {
        $fields = ContentHelper::extractFieldsInputFromRequest($request);
        $domain = $request->input('domain');
        if ($domain == null || ! in_array(Str::lower($domain), ['contents', 'sections'])) {
            $domain = 'contents';
        }

        /** @var User $user */
        $user = Auth::user();
        $class = 'Inside\Content\Models\\'.Str::studly($domain).'\\'.Str::studly($request->input('related_type'));
        $uuid = $request->input('related_uuid');
        $requestedContent = call_user_func($class.'::findOrFail', $uuid);
        $translateContents = $class::where('uuid_host', $requestedContent->uuid_host)->get();

        $reactions = Reactions::get(
            type: $request->input('type'),
            reactionableUuid: $uuid,
            user: $user->uuid,
            langcode: $requestedContent->langcode,
            reactionableType: $class,
            fields: $fields,
            formated: false
        );

        if ($reactions->isNotEmpty()) {
            return response()->json($reactions);
        }

        $translateContents->each(
            fn ($content) => Reactions::create([
                'user_uuid' => $user->uuid,
                'reactionable_uuid' => $content->uuid,
                'reactionable_type' => $class,
                'type' => $request->input('type'),
                'langcode' => $content->langcode,
            ])
        );

        return response()->json(Reactions::getFormatted());
    }
}
