<?php

namespace Inside\Reaction\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Content\Facades\ContentHelper;
use Inside\Reaction\Facades\Reactions;

class Index extends Controller
{
    public function __invoke(Request $request, string $type, string $related): JsonResponse
    {
        $fields = ContentHelper::extractFieldsInputFromRequest($request);
        $filters = ContentHelper::extractFiltersInputFromRequest($request);

        return response()->json(Reactions::list($type, $related, $filters, $fields));
    }
}
