<?php

namespace Inside\Reaction\Events;

use Illuminate\Broadcasting\InteractsWithSockets;
use Illuminate\Broadcasting\PrivateChannel;
use Illuminate\Contracts\Auth\Authenticatable;
use Illuminate\Contracts\Broadcasting\ShouldBroadcast;
use Inside\Authentication\Models\User;
use Inside\Events\Dispatchable;
use Inside\Reaction\Models\Reaction;

class ReactionUnsubscribedEvent implements ShouldBroadcast
{
    use InteractsWithSockets;
    use Dispatchable;

    public User $user;

    public function __construct(
        public Reaction $reaction
    ) {
        $this->user = User::findOrFail($reaction->user->uuid);
    }

    public function broadcastOn(): PrivateChannel
    {
        return new PrivateChannel('inside.reactions.'.$this->user->uuid);
    }

    public function broadcastAs(): string
    {
        return 'inside.reaction.unsubscribed';
    }

    public function broadcastWith(): array
    {
        return [
            'user' => $this->user->with('information'),
            'reaction' => $this->reaction,
        ];
    }
}
