<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class AlterReactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        if (Schema::hasColumn('inside_reactions', 'user_uuid')) {
            Schema::table('inside_reactions', function (Blueprint $table) {
                $table->dropForeign($table->getTable().'_user_uuid_foreign');
            });
            Schema::table('inside_reactions', function (Blueprint $table) {
                $table->foreign('user_uuid')->references('uuid')->on('inside_users')->onDelete('cascade');
            });
        }
    }
}
