<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateReactionsTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('inside_reactions', function (Blueprint $table) {
            $table->increments('id');
            $table->string('type', 255)->nullable();
            $table->uuid('user_uuid')->collate('utf8');
            $table->uuid('reactionable_uuid')->collate('utf8');
            $table->string('reactionable_type', 255);
            $table->char('langcode', 2)->nullable();
            $table->timestamps();
            $table->index(['user_uuid', 'type']);
            $table->index('reactionable_uuid');
            $table->index('langcode');
            $table->foreign('user_uuid')
                ->references('uuid')->on('inside_content_users')
                ->onDelete('cascade');
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('inside_reactions');
    }
}
