<?php

use Illuminate\Support\Facades\Route;

Route::group(
    [
        'namespace'  => 'Inside\Permission\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => ['auth.role:super_administrator'],
    ],
    function ($router) {
        // Role
        $router->post('role', ['uses' => 'RoleController@post']);
        $router->put('role/{roleId}', ['uses' => 'RoleController@put']);
        $router->delete('role/{roleId}', ['uses' => 'RoleController@delete']);

        // Category
        $router->get('role/category', ['uses' => 'RoleController@listCategory']);
        $router->post('role/category', ['uses' => 'RoleController@postCategory']);
        $router->put('role/category/{categoryId}', ['uses' => 'RoleController@putCategory']);
        $router->delete('role/category/{categoryId}', ['uses' => 'RoleController@deleteCategory']);

        // Get role (avoid shadowed with GET /role/category)
        $router->get('role[/{root}]', ['uses' => 'RoleController@index']);
        // Assign and list users to specific role
        $router->put('role/user/sync/{roleId}', ['uses' => 'RoleController@userSync']);

        // Permission
        $router->get('permission/{roleId}', ['uses' => 'PermissionController@index']);
        $router->post('permission/{roleId}', ['uses' => 'PermissionController@post']);

        // Backoffice entries
        $router->get('permission/backoffice_entries/{roleId}', ['uses' => 'BackofficeEntriesController@edit']);
        $router->put('permission/backoffice_entries/{roleId}', ['uses' => 'BackofficeEntriesController@update']);
    }
);

Route::group(
    [
        'namespace'  => 'Inside\Permission\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.api',
    ],
    function ($router) {
        $router->get('role/user/list/{roleIds}', ['uses' => 'RoleController@userList']);
        $router->get('role/user/roles', ['uses' => 'RoleController@userRoles']);
    }
);

Route::group(
    [
        'namespace'  => 'Inside\Permission\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.backoffice.access:user',
    ],
    function ($router) {
        $router->get('permission/user/{uuid}', ['uses' => 'PermissionController@user']);
    }
);

Route::group(
    [
        'namespace'  => 'Inside\Permission\Exodus\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.backoffice.access:content',
    ],
    function ($router) {
        $router->post('precompute-capabilities/{type}', ['uses' => 'PrecomputeCapabilitiesOnContent']);
    }
);

Route::group(
    [
        'namespace'  => 'Inside\Permission\Exodus\Http\Controllers',
        'prefix'     => 'api/v1',
        'middleware' => 'auth.backoffice.access:user',
    ],
    function ($router) {
        //Backoffice Access Restriction
        $router->get('user/{userUuid}/combined-backoffice-access-restriction', ['uses' => 'BackofficeAccessRestriction@combined']);

        //Content Type Access Restriction
        $router->get('user/{userUuid}/combined-content-type-access-restriction', ['uses' => 'ContentTypeAccessRestriction@combined']);

        //Categorizable Content Access Restriction
        $router->get('user/{userUuid}/combined-categorizable-content-access-restriction', ['uses' => 'CategorizableContentAccessRestriction@combined']);

        //Menu Acccess Restriction
        $router->get('user/{userUuid}/combined-menu-access-restriction', ['uses' => 'MenuAccessRestriction@combined']);
    }
);

Route::group(
    [
        'namespace'  => 'Inside\Permission\Exodus\Http\Controllers',
        'prefix' => 'api/v1',
        'middleware' => ['auth.role:super_administrator'],
    ],
    function ($router) {
        //Backoffice Access Restriction
        $router->get('role/{roleId}/backoffice-access-restriction', ['uses' => 'BackofficeAccessRestriction@index']);
        $router->post('role/{roleId}/backoffice-access-restriction', ['uses' => 'BackofficeAccessRestriction@store']);

        //Content Type Access Restriction
        $router->get('role/{roleId}/content-type-access-restriction', ['uses' => 'ContentTypeAccessRestriction@index']);
        $router->post('role/{roleId}/content-type-access-restriction', ['uses' => 'ContentTypeAccessRestriction@store']);

        //Categorizable Content Access Restriction
        $router->get('role/{roleId}/categorizable-content-access-restriction', ['uses' => 'CategorizableContentAccessRestriction@index']);
        $router->post('role/{roleId}/categorizable-content-access-restriction', ['uses' => 'CategorizableContentAccessRestriction@store']);

        //Menu Acccess Restriction
        $router->get('role/{roleId}/menu-access-restriction', ['uses' => 'MenuAccessRestriction@index']);
        $router->post('role/{roleId}/menu-access-restriction', ['uses' => 'MenuAccessRestriction@store']);
    }
);
