<?php

namespace Inside\Permission\Models\Traits;

use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Support\Facades\Event;
use Inside\Authentication\Events\UserCreatedEvent;
use Inside\Authentication\Events\UserDeletedEvent;
use Inside\Authentication\Events\UserUpdatedEvent;
use Inside\Permission\Models\Permission;

trait HasPermissions
{
    public static function bootRefreshBackofficeEntriesCache()
    {
        static::created(
            function ($user) {
                Event::dispatch(new UserCreatedEvent($user));
            }
        );

        static::updated(
            function ($user) {
                Event::dispatch(new UserUpdatedEvent($user));
            }
        );

        static::deleted(
            function ($user) {
                Event::dispatch(new UserDeletedEvent($user));
            }
        );
    }

    /**
     * Get all user permissions.
     *
     * @return BelongsToMany
     */
    public function permissions(): BelongsToMany
    {
        return $this->belongsToMany(
            Permission::class,
            'inside_users_permissions_schema',
            'user_uuid',
            'permission_id'
        );
    }
}
