<?php

namespace Inside\Permission\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;

/**
 * @property string $authorizable_uuid
 *
 * @mixin Builder
 * @mixin \Eloquent
 * @property int $id
 * @property bool $invert
 * @property bool $children
 * @property string $action
 * @property string $authorizable_uuid
 * @property string $authorizable_type
 * @property Role[] $roles
 */
class PermissionSchema extends Model
{
    /**
     * The table without the timestamps.
     *
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = 'inside_permissions_schema';

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $guarded = ['id'];

    /**
     * The attributes that are hidden.
     *
     * @var array
     */
    protected $hidden = [
        'id',
        'condition',
        'custom',
        'field_name',
        'field_value',
    ];

    /**
     * The attributes that are fillable
     *
     * @var array
     */
    protected $fillable = [
        'invert',
        'children',
        'action',
        'authorizable_type',
        'authorizable_uuid',
        'field_name',
        'field_value',
        'condition',
        'custom',
    ];

    /**
     * The attributes that should be casted to native types.
     *
     * @var array
     */
    protected $casts = [
        'invert'   => 'boolean',
        'children' => 'boolean',
    ];

    /**
     * Get all permissions roles.
     *
     * @return BelongsToMany
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(
            Role::class,
            'inside_roles_permissions_schema',
            'permission_schema_id',
            'role_id'
        );
    }

    /**
     * Get all permissions users.
     *
     * @return BelongsToMany
     */
    public function users(): BelongsToMany
    {
        return $this->belongsToMany(
            User::class,
            'inside_users_permissions_schema',
            'permission_schema_id',
            'user_uuid'
        );
    }
}
