<?php

namespace Inside\Permission\Listeners;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Support\Facades\Log;
use Inside\Authentication\Models\User;
use Inside\User\Events\UserDisabledEvent;

/**
 * User disabled listener
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class UserDisabledListener implements ShouldQueue
{
    public function handle(UserDisabledEvent $event): void
    {
        $user = User::find($event->userUuid);

        if (! $user instanceof User) {
            return;
        }

        Log::info('[user-disabled] Suppression des roles de <'.$event->userUuid.'>');
        $user->revokeAllRoles();
    }
}
