<?php

namespace Inside\Permission\Http\Middlewares;

use Closure;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Inside\Permission\Facades\Permission;

/**
 * Inside Permission middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class SuperAdminMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure                 $next
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $user = $request->user();

        if (! $user || ! Permission::isSuperAdmin($user)) {
            Log::info('Unauthorized', ['uri' => $request->getUri()]);

            return new JsonResponse(['error' => 'Unauthorized'], 403);
        }

        return $next($request);
    }
}
