<?php

namespace Inside\Permission\Http\Middlewares;

use Closure;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

/**
 * Inside Role middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class RoleMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure                 $next
     * @param array|string $role
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $role)
    {
        $user = $request->user();

        if (! $user) {
            Log::info('Unauthorized', ['uri' => $request->getUri()]);

            return new JsonResponse(['error' => 'Unauthorized'], 403);
        }
        $roles = is_array($role) ? $role : explode('|', $role);

        if (! $user->hasAnyRole($roles)) {
            Log::info('Unauthorized', ['uri' => $request->getUri()]);

            return new JsonResponse(['error' => 'Unauthorized'], 403);
        }

        return $next($request);
    }
}
