<?php

namespace Inside\Permission\Http\Middlewares;

use Closure;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Inside\Permission\Facades\Permission;
use Symfony\Component\HttpFoundation\BinaryFileResponse;
use Symfony\Component\HttpFoundation\Response;

/**
 * Add role to current and login queries
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class LayoutPermissionMiddleware
{
    /**
     * The path where permission are injected
     *
     * @var array
     */
    private $paths = [
        'api/v1/layout',
    ];

    /**
     * Handle an incoming request.
     *
     * @param Request $request
     * @param Closure                 $next
     *
     * @return mixed
     */
    public function handle(Request $request, Closure $next)
    {
        $response = $next($request);
        if ($response instanceof Response && $response->getStatusCode() != 200) {
            return $response;
        }

        $path = $request->path();
        if (! in_array($path, $this->paths)) {
            return $response;
        }
        /** @var array|null $content */
        $content = json_decode_response($response);
        if ($content === null) {
            return $response;
        }

        if (isset($content['data']) && isset($content['data']['uuid'])) {
            $class = table_to_class($content['data']['type']);

            $model = call_user_func($class.'::find', $content['data']['uuid']);

            if (! $model) {
                Log::info('Not found', ['uri' => $request->getUri()]);

                return new JsonResponse(['error' => 'Not found'], 404);
            }

            if (! Permission::can('read', $model)) {
                Log::info('Unauthorized', ['uri' => $request->getUri()]);

                return new JsonResponse(['error' => 'Unauthenticated.'], 403);
            }
        }

        return $response;
    }
}
