<?php

namespace Inside\Permission\Http\Middlewares;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;
use Inside\Permission\Exceptions\UnauthorizedException;

/**
 * Inside Role middleware.
 *
 * @category Class
 * @author   Maecia <technique@maecia.com>
 * @license  http://www.gnu.org/copyleft/gpl.html GNU General Public License
 * @link     http://www.maecia.com/
 */
class BackofficeEntryMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  Request  $request
     * @param  Closure  $next
     * @param  string|array  $backofficeEntry
     * @return mixed
     */
    public function handle(Request $request, Closure $next, $backofficeEntry)
    {
        $authGuard = app('auth')->guard();

        if ($authGuard->guest()) {
            throw UnauthorizedException::notLoggedIn();
        }
        $backofficeEntries = is_array($backofficeEntry) ? $backofficeEntry : explode('|', $backofficeEntry);

        foreach ($backofficeEntries as $backofficeEntry) {
            if ($authGuard->user()->can('access_'.$backofficeEntry)) {
                return $next($request);
            }
        }
        Log::info('Unauthorized', ['uri' => $request->getUri(), 'entries' => $backofficeEntries]);

        throw UnauthorizedException::forBackofficeEntries($backofficeEntries);
    }
}
