<?php

namespace Inside\Permission\Http\Controllers;

use Illuminate\Http\JsonResponse;
use Illuminate\Http\Request;
use Inside\Facades\Inside;
use Inside\Permission\Events\BackofficeEntriesPermissionChangedEvents;
use Inside\Permission\Facades\Permission;
use Inside\Validation\Rule;
use Laravel\Lumen\Routing\Controller;

class BackofficeEntriesController extends Controller
{
    public function edit(int $roleId): JsonResponse
    {
        return new JsonResponse(Permission::getBackofficeEntriesForRole($roleId));
    }

    public function update(Request $request, int $roleId): JsonResponse
    {
        $this->validate($request, [
            'entries' =>  ['array', Rule::in(Inside::getAllBackofficeEntries()->toArray())],
        ]);
        Permission::updateBackofficeEntriesForRole($roleId, $request->get('entries', []));

        BackofficeEntriesPermissionChangedEvents::dispatch($roleId, Permission::getBackofficeEntriesForRole($roleId));

        return new JsonResponse(Permission::getBackofficeEntriesForRole($roleId));
    }
}
