<?php

namespace Inside\Permission\Exodus\Services\ViewIndexer;

use Illuminate\Database\Query\Builder;
use Illuminate\Support\Collection;
use Illuminate\Support\Facades\DB;

abstract class BaseViewIndexer
{
    abstract protected function getModels(): Collection;

    abstract protected function selectQueryBuilder(string $class): Builder;

    protected function unionModels(): string
    {
        return $this
            ->getModels()
            ->map(fn (string $class) => $this->selectQueryBuilder($class))
            ->reduce(fn (?Builder $query, Builder $next) => is_null($query) ? $next : $query->union($next))
            ->toSql();
    }

    public static function create(): void
    {
        $subQuery = (new static)->unionModels();

        DB::statement('CREATE VIEW '.static::TABLE.' AS SELECT * FROM ('.$subQuery.') AS '.static::TABLE);
    }

    public static function refresh(): void
    {
        $subQuery = (new static)->unionModels();

        DB::statement('CREATE OR REPLACE VIEW '.static::TABLE.' AS SELECT * FROM ('.$subQuery.') AS '.static::TABLE);
    }

    public static function drop(): void
    {
        try {
            DB::statement('DROP VIEW '.static::TABLE);
        } catch (\Exception $e) {
            // Depending on the backup process, the view can be restored as a table and we need to drop it
            if (str($e->getMessage())->contains('is not VIEW')) {
                DB::statement('DROP TABLE '.static::TABLE);
            }
        }
    }

    public static function reset(): void
    {
        self::drop();
        self::create();
    }
}
