<?php

namespace Inside\Permission\Exodus\Services\AccessRestriction;

use Illuminate\Support\Collection;
use Inside\Host\Exodus\Services\ContentTypeStatusService;
use Inside\Permission\Exodus\Contracts\AccessRestrictions;
use Inside\Permission\Exodus\Dto\Privileges\ContentTypePrivilegeDto;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;
use Inside\Permission\Exodus\Services\AccessRestriction\Traits\HasCapababilities;

final class ContentTypeAccessRestriction extends BaseAccessRestriction implements AccessRestrictions
{
    use HasCapababilities;

    private static array $capabilities = [
        CapabilityEnum::READ,
        CapabilityEnum::CREATE,
        CapabilityEnum::UPDATE,
        CapabilityEnum::DELETE,
    ];

    /**
     * @return Collection<ContentTypePrivilegeDto>
     */
    public static function expected(): Collection
    {
        return app(ContentTypeStatusService::class)
            ->permissibles()
            ->collect()
            ->pluck('type')
            ->map(fn (string $type) => type_to_class($type))
            ->crossJoin(self::availableCapabilities())
            ->map(fn (array $privileges) => ContentTypePrivilegeDto::from(...$privileges));
    }

    /**
     * @return Collection<ContentTypePrivilegeDto>
     */
    public static function availables(): Collection
    {
        return ContentTypePrivilege::query()->get()->collect()->map(
            fn (ContentTypePrivilege $contentTypePrivilege) => ContentTypePrivilegeDto::fromModel($contentTypePrivilege)
        );
    }
}
