<?php

namespace Inside\Permission\Exodus\Services\AccessRestriction;

use Illuminate\Support\Collection;
use Inside\Permission\Exodus\Contracts\AccessRestrictions;
use Inside\Permission\Exodus\Dto\CapabilityDto;
use Inside\Permission\Exodus\Dto\Indexes\PermissibleContentIndexDto;
use Inside\Permission\Exodus\Dto\Privileges\ContentPrivilegeDto;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Privileges\CategorizableContentPrivilege;
use Inside\Permission\Exodus\Models\ViewModels\CategorizableContentIndex;
use Inside\Permission\Exodus\Services\AccessRestriction\Traits\HasCapababilities;

final class CategorizableContentAccessRestriction extends BaseAccessRestriction implements AccessRestrictions
{
    use HasCapababilities;

    private static array $capabilities = [
        CapabilityEnum::READ,
        CapabilityEnum::ASSIGN,
        CapabilityEnum::UPDATE,
        CapabilityEnum::DELETE,
    ];

    /**
     * @return Collection<ContentPrivilegeDto>
     */
    public static function expected(): Collection
    {
        return CategorizableContentIndex::all()
            ->crossJoin(self::availableCapabilities())
            ->map(function (array $privileges) {
                /** @var CategorizableContentIndex $index */
                /** @var CapabilityDto $capability */
                [$index, $capability] = $privileges;

                return ContentPrivilegeDto::from(
                    PermissibleContentIndexDto::fromModel($index),
                    $capability,
                );
            });
    }

    /**
     * @return Collection<ContentPrivilegeDto>
     */
    public static function availables(): Collection
    {
        return CategorizableContentPrivilege::query()->get()->collect()->map(
            fn (CategorizableContentPrivilege $privilege) => ContentPrivilegeDto::fromModel($privilege)
        );
    }
}
