<?php

namespace Inside\Permission\Exodus\Services\AccessRestriction;

use Illuminate\Support\Collection;
use Inside\Permission\Exodus\Contracts\AccessRestrictions;

abstract class BaseAccessRestriction implements AccessRestrictions
{
    abstract public static function expected(): Collection;

    abstract public static function availables(): Collection;

    public static function missing(): Collection
    {
        return static::expected()->diff(static::availables());
    }

    public static function unnecessaries(): Collection
    {
        return static::availables()->diff(static::expected());
    }
}
