<?php

namespace Inside\Permission\Exodus\Models\ViewModels;

use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\MorphTo;
use Inside\Content\Models\Content;
use Inside\Permission\Scopes\AllowedScope;

/**
 * @property string $uuid_host
 * @property string $translatable_uuid
 * @property string $translatable_type
 * @property ?Content $translatable
 */
final class ContentTranslationIndexes extends ViewModel
{
    const TABLE = 'exodus_content_translation_indexes';

    protected $table = self::TABLE;

    protected $primaryKey = 'translatable_uuid';

    protected $keyType = 'string';

    protected $with = [
        'translatable',
    ];

    public function translatable(): MorphTo
    {
        return $this->morphTo('translatable', 'translatable_type', 'translatable_uuid', 'uuid')->withoutGlobalScope(AllowedScope::class);
    }
}
