<?php

namespace Inside\Permission\Exodus\Models\Privileges;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Inside\Permission\Exodus\Enums\CapabilityEnum;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Models\Role;
use Inside\Permission\Exodus\Models\ViewModels\ContentTranslationIndexes;

/**
 * @property int $id
 * @property int $capability_id
 * @property string $type
 * @property Capability $capability
 * @property ContentTranslationIndexes $index
 * @property Collection<Role> $roles
 * @mixin Builder
 */
class ContentSpecificPrivilege extends ContentPrivilege
{
    const TABLE = 'exodus_content_privileges';

    const PIVOT_ROLE_TABLE = 'exodus_content_specific_privilege_role';

    protected static function boot(): void
    {
        parent::boot();

        static::addGlobalScope('onlyReadableCapability', function (Builder $builder) {
            $builder->whereHas('capability', function (Builder $query) {
                $query->where('name', CapabilityEnum::READ);
            });
        });
    }
}
