<?php

namespace Inside\Permission\Exodus\Models\Privileges;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Inside\Permission\Exodus\Models\Capability;
use Inside\Permission\Exodus\Models\Role;

/**
 * @property int $id
 * @property int $capability_id
 * @property string $name
 * @property Capability $capability
 * @property Collection<Role> $roles
 * @mixin Builder
 */
class BackofficePrivilege extends Model
{
    const TABLE = 'exodus_backoffice_privileges';

    const PIVOT_ROLE_TABLE = 'exodus_backoffice_privilege_role';

    const TRANSLATION_PREFIX = 'permission.backoffice_entries.';

    /**
     * The table without the timestamps.
     * v
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = self::TABLE;

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $fillable = [
        'capability_id',
        'name',
    ];

    protected $with = [
        'capability',
    ];

    /**
     * @mixin Builder
     * @return BelongsToMany
     */
    public function roles(): BelongsToMany
    {
        return $this->belongsToMany(
            related: Role::class,
            table: self::PIVOT_ROLE_TABLE,
            foreignPivotKey: 'backoffice_section_id',
            relatedPivotKey: 'role_id'
        )->withPivot('pivot_id');
    }

    /**
     * @mixin \Inside\Database\Eloquent\Builder
     * @return BelongsTo
     */
    public function capability(): BelongsTo
    {
        return $this->belongsTo(Capability::class, 'capability_id', 'id');
    }
}
