<?php

namespace Inside\Permission\Exodus\Models;

use Illuminate\Database\Eloquent\Builder;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasMany;
use Inside\Permission\Exodus\Models\Privileges\BackofficePrivilege;
use Inside\Permission\Exodus\Models\Privileges\CategorizableContentPrivilege;
use Inside\Permission\Exodus\Models\Privileges\ContentSpecificPrivilege;
use Inside\Permission\Exodus\Models\Privileges\ContentTypePrivilege;

/**
 * @property int $id
 * @property string $name
 * @property Collection<CategorizableContentPrivilege> $categorizableContents
 * @property Collection<ContentSpecificPrivilege> $contentSpecifics
 * @property Collection<ContentTypePrivilege> $contentTypes
 * @property Collection<BackofficePrivilege> $backoffices
 * @mixin Builder
 */
class Capability extends Model
{
    const TABLE = 'exodus_capabilities';

    /**
     * The table without the timestamps.
     * @var bool
     */
    public $timestamps = false;

    /**
     * The table associated with the model.
     *
     * @var string
     */
    protected $table = self::TABLE;

    /**
     * The attributes that are guarded.
     *
     * @var array
     */
    protected $fillable = [
        'name',
    ];

    protected $hidden = [
        'id',
    ];

    /**
     * @mixin Builder
     * @return Hasmany
     */
    public function categorizableContents(): HasMany
    {
        return $this->hasMany(CategorizableContentPrivilege::class, 'capability_id');
    }

    /**
     * @mixin Builder
     * @return Hasmany
     */
    public function contentSpecifics(): HasMany
    {
        return $this->hasMany(ContentSpecificPrivilege::class, 'capability_id');
    }

    /**
     * @mixin Builder
     * @return HasMany
     */
    public function contentTypes(): HasMany
    {
        return $this->hasMany(ContentTypePrivilege::class, 'capability_id');
    }

    public function backoffices(): HasMany
    {
        return $this->hasMany(BackofficePrivilege::class, 'capability_id');
    }
}
