<?php

namespace Inside\Permission\Exodus\Listeners;

use Illuminate\Support\Facades\Log;
use Inside\Content\Events\ContentDeletedEvent;
use Inside\Content\Models\Content;
use Inside\Permission\Exodus\Actions\RefreshViewTables\RefreshCategorizableContentIndexesViewTable;
use Inside\Permission\Exodus\Actions\RefreshViewTables\RefreshCategorizableContentTranslationIndexesViewTable;
use Inside\Permission\Exodus\Actions\RemoveUnnecessaries\RemoveUnnecessaryCategorizablePrivileges;
use Inside\Permission\Exodus\Services\RolePrivilegesService;

class RemovePrivilegesOnDeletedCategorizableContent
{
    public function handle(ContentDeletedEvent $event): void
    {
        /** @var Content $model */
        $model = $event->model;

        if (! $model::isPermissible() || ! $model::isCategorizable()) {
            return;
        }

        (new RemoveUnnecessaryCategorizablePrivileges())->execute();
        (new RefreshCategorizableContentTranslationIndexesViewTable())->execute();
        (new RefreshCategorizableContentIndexesViewTable())->execute();

        RolePrivilegesService::clearAllCache();
    }
}
